/* -*- mode: C++; tab-width: 4 -*- */
/* ===================================================================== *\
	Copyright (c) 2001 Palm, Inc. or its subsidiaries.
	All rights reserved.

	This file is part of the Palm OS Emulator.

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.
\* ===================================================================== */

#ifndef EmRegsVZMorf_h
#define EmRegsVZMorf_h

#include "EmRegsVZ.h"
#include "EmRegsVZVisorPlatinum.h"

// These need to be set to the largest number of rows and columns that
// we need to support. DOLATER: Make this dynamic.

#define maxNumRows	6
#define maxNumCols	8

class EmRegsVZMorfKeyMatrix
{
	public:
								EmRegsVZMorfKeyMatrix		(bool SheaID);
		virtual					~EmRegsVZMorfKeyMatrix		(void);

		virtual uint32			ReadMatrix			(UInt8 portKMask, UInt8 portEMask);
		virtual uint8			GetColumnBits		(int row);
		virtual void			ResetMatrixState	();
		virtual Bool			SetMatrixState		(Bool state, SkinElementType element);

	private:
		int		matrixState[maxNumRows][maxNumCols];
		int		numRows;
		int		numCols;
};

class EmRegsVZMorf: public EmRegsVZVisorPlatinum
{
	public:
								EmRegsVZMorf		    (void);
		virtual					~EmRegsVZMorf			(void);
		virtual Bool			GetLCDScreenOn			(void);
		virtual Bool			GetLCDBacklightOn		(void);
		virtual Bool			GetLCDHasFrame			(void);
		virtual void			GetLCDBeginEnd			(emuptr& begin, emuptr& end);
		virtual void			GetLCDScanlines			(EmScreenUpdateInfo& info);

		virtual uint16			GetLEDState (void);

		virtual uint8			GetPortInputValue		(int port);
		virtual uint8			GetPortInternalValue	(int port);

	protected:
		virtual void			ButtonEvent				(SkinElementType, Bool buttonIsDown);

		virtual uint8			GetKeyBits				(void);

	private:
		int		lidState;
		EmRegsVZMorfKeyMatrix* keyMatrixP;
};
#endif	/* EmRegsVZMorf_h */
